$(function(){
    let cartHeaderElement = $('#cart_btn_new').parent();


    function refreshCart()
    {
        $('body').addClass('loading');
        $.ajax({
            type: 'POST',
            url: 'https://www.mechandealershop.nl/nl/agco/cart/info',
            dataType: "json",
            xhrFields: {
                withCredentials: true
            },
            success: function (response) {
                $('body').removeClass('loading');
              $('.items-in-cart').html(response.total);
            },
            error: function(){
                $('body').removeClass('loading');
            }
        });
    }

    refreshCart();

    $('body').on('click', '.refresh', function(){
        refreshCart();
    });


    cartHeaderElement.append('<button id="shopMechangroepBtn" title="Verstuur naar Mechandealer" class="btn btn-default btn-xs">\n' +
        '                                            <i class="fas fa-shopping-cart"></i> Verstuur naar Mechandealer \n' +
        '                                        </button>').find('#shopMechangroepBtn').click(function(){
            let cart = getCart();
            let selectedParts = [];


            console.log(cart);

            $('body').addClass('loading');

            if (cart.items && cart.items.length > 0)
            {
                cart.items.forEach(function(item, index){
                    selectedParts.push({
                        part: item.partnumber,
                        qty : item.partqty,
                        desc: item.Note,
                        techDesc: item.TechSpec,
                        partDesc: item.partdescription,
                    });
                });

            }

            if(selectedParts.length > 0) {
                let url = "https://www.mechandealershop.nl/nl/agco/cart/json";

                $.ajax({
                    type: 'POST',
                    url: url,
                    data: JSON.stringify(selectedParts),
                    dataType: "json",
                    contentType: "application/json; charset=utf-8",
                    xhrFields: {
                        withCredentials: true
                    },
                    error: function(){
                        $('body').removeClass('loading');
                    },
                    success: function(response){


                        $('body').removeClass('loading');
                        if (response.code == 'NOT_LOGGED_IN')
                        {
                            Swal.fire({
                                text: response.msg,
                                type: 'error',
                                showCancelButton: true,
                                confirmButtonText: 'Inloggen',
                                cancelButtonText: 'Sluiten',
                                confirmButtonColor: '#79b637',
                            }).then(function(result){
                                if (result.value) {
                                    window.open('https://www.mechandealershop.nl/nl/customer/account/login/');
                                }
                            });
                        }
                        else if (response.code == 'SUCCESS')
                        {
                            Swal.fire({
                                text: response.msg,
                                type: 'success',
                                showCancelButton: true,
                                confirmButtonText: 'Open Mechandealershop winkelwagen in nieuw tabblad',
                                cancelButtonText: 'Sluiten',
                                confirmButtonColor: '#79b637',
                            }).then(function(result){
                                if (result.value) {
                                    window.open('https://www.mechandealershop.nl/nl/checkout/cart/');
                                }

                                $("#cart_btn_new").trigger('click');
                                refreshCart();
                            });
                        }
                    }
                });

            } else {
                $('body').removeClass('loading');
                Swal.fire('', "Voeg eerst producten toe aan uw basket.", 'error');
            }
    });
});